<?php
/**
* @package Admin-User-Access (com_pi_admin_user_access)
* @version 2.4.0
* @copyright Copyright (C) 2007-2011 Carsten Engel. All rights reserved.
* @license GPL available versions: free, trial and pro
* @author http://www.pages-and-items.com
* @joomla Joomla is Free Software
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

class plgSystemAdminuseraccess extends JPlugin{
	
	var $user_id;
	var $user_type;	
	
	function plgSystemAdminuseraccess(& $subject, $config){
		parent::__construct($subject, $config);				
	}
	
	function get_config(){
		$database = JFactory::getDBO();
		$database->setQuery("SELECT config "
		."FROM #__pi_aua_config "
		."WHERE id='aua' "
		."LIMIT 1"
		);
		$temp = $database->loadObjectList();
		$temp = $temp[0];
		$raw = $temp->config;	
		
		$params = explode( "\n", $raw);
		
		for($n = 0; $n < count($params); $n++){		
			$temp = explode('=',$params[$n]);
			$var = $temp[0];
			$value = '';
			if(count($temp)==2){
				$value = trim($temp[1]);
				if($value=='false'){
					$value = false;
				}
				if($value=='true'){
					$value = true;
				}
			}							
			$config[$var] = $value;	
		}	
		return $config;			
	}
	
	function onAfterContentSave($article, $isNew){
		if($isNew){
			//only when new article is saved
			
			$config = $this->get_config();
			if($config['active_actions'] && $this->user_type!='Super Administrator'){
						
				$database = JFactory::getDBO();	
				$app = JFactory::getApplication();			
				$this->get_user();				
				
				$database->setQuery("SELECT action_usergroupid FROM #__pi_aua_actions");
				$action_permissions = $database->loadResultArray();
				
				//get the users AUA group
				$database->setQuery("SELECT group_id "
				." FROM #__pi_aua_userindex "
				." WHERE user_id='$this->user_id' "
				." LIMIT 1 "
				);
				$rows = $database->loadObjectList();
				$group = 0;
				foreach($rows as $row){	
					$group = $row->group_id;
				}				
				
				if($app->isAdmin()){
					$number = '197';	
				}else{
					$number = '198';	
				}	
				$actionRight = $number.'__'.$group;	
					
				if(in_array($actionRight, $action_permissions)){
					$article_right = $article->id.'__'.$group;
									
					//add module right to database
					$database->setQuery( "INSERT INTO #__pi_aua_items SET itemid_usergroupid='$article_right' ");
					$database->query();
				}	
			}		
		}	
	}
	
	function get_user(){
		//userdata needs to be collected on the eventload as loading them in the constructor does not work with CB login module
		$user = JFactory::getUser();		
		$this->user_id = $user->get('id');		
		$this->user_type = $user->get('usertype');
	}
	
	function onAfterInitialise(){		
		
		//do frontend checking
		require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_pi_admin_user_access'.DS.'plugin_system'.DS.'old_frontend_module.php');		
		
		$app = JFactory::getApplication();
		if($app->isAdmin()){
			//only do stuff at backend
			
			$aua_config = $this->get_config();
			
			$database = JFactory::getDBO();
			
			//check if there is a new module
			$new_module = $app->getUserState( "com_adminuseraccess.newmodule", '' );
			
			if($new_module){
				//reset session
				$app->setUserState( "com_adminuseraccess.newmodule", '' );
				
				//echo 'new_module='.$new_module;
			//exit;

				
				//check workflow if this needs to be done
				$config = $this->get_config();
				$this->get_user();	
				if($config['active_actions'] && $this->user_type!='Super Administrator'){					
					
					$database->setQuery("SELECT action_usergroupid FROM #__pi_aua_actions");
					$action_permissions = $database->loadResultArray();
					
					//get the users AUA group
					$database->setQuery("SELECT group_id "
					." FROM #__pi_aua_userindex "
					." WHERE user_id='$this->user_id' "
					." LIMIT 1 "
					);
					$rows = $database->loadObjectList();
					$group = 0;
					foreach($rows as $row){	
						$group = $row->group_id;
					}					
					
					if($new_module=='save' || $new_module=='apply'){
						$number = '196';
					}else{
						//copy
						$number = '199';
					}
					$actionRight = $number.'__'.$group;			
					if(in_array($actionRight, $action_permissions)){					
				
						//get all the old module ids
						$database->setQuery("SELECT config "
						." FROM #__pi_aua_config "
						." WHERE id='module_ids' "			
						);
						$rows = $database->loadObjectList();
						$module_ids_string = '';
						foreach($rows as $row){	
							$module_ids_string = $row->config;	
						}
						
						
						
						if($module_ids_string!=''){
							$old_module_ids_array = $this->csv_to_array($module_ids_string);
							
							//get all current module id's
							$database->setQuery("SELECT id "
							." FROM #__modules "			
							);
							$module_ids_array = $database->loadResultArray();
							
							$new_module_ids_array = array();
							for($n = 0; $n < count($module_ids_array); $n++){
								$id = $module_ids_array[$n];
								if(!in_array($id, $old_module_ids_array)){
									$new_module_ids_array[] = $id;									
								}
							}	
							
							//print_r($new_module_ids_array);	
							//exit;								
							
							if(count($new_module_ids_array)){													
								
								//get the users AUA group
								$database->setQuery("SELECT group_id "
								." FROM #__pi_aua_userindex "
								." WHERE user_id='$this->user_id' "
								." LIMIT 1 "
								);
								$rows = $database->loadObjectList();
								$group = 0;
								foreach($rows as $row){	
									$group = $row->group_id;
								}
								
								if($group){
									foreach($new_module_ids_array as $new_module_id){
										$module_right = $new_module_id.'__'.$group;
										
										//add module right to database
										$database->setQuery( "INSERT INTO #__pi_aua_modules SET module_groupid='$module_right' ");
										$database->query();
									}
								}
								
							}
						}
					}
				}				
			}			
			
			$option = JRequest::getVar('option', '');
			$id = JRequest::getVar('id', '');
			$task = JRequest::getVar('task', '');			
			if(
			($option=='com_modules' || $option=='com_advancedmodules') && 
			((($task=='save' || $task=='apply') && $id==0) || $task=='copy')			
			){
				//a new module has been saved OR module(s) have been copied			
				
				//get all current module id's
				$database->setQuery("SELECT id "
				." FROM #__modules "			
				);
				$module_ids_array = $database->loadResultArray();			
							
				$module_ids_string = $this->array_to_csv($module_ids_array);			
				
				//check if there is a row for the module ids yet
				$database->setQuery("SELECT config "
				." FROM #__pi_aua_config "
				." WHERE id='module_ids' "			
				);
				$rows = $database->loadObjectList();
				$has_row = 0;
				foreach($rows as $row){	
					$has_row = 1;	
				}
				
				//insert or update
				if(!$has_row){
					//insert
					$database->setQuery( "INSERT INTO #__pi_aua_config SET id='module_ids', config='$module_ids_string' ");
				}else{
					//update
					$database->setQuery( "UPDATE #__pi_aua_config SET config='$module_ids_string' WHERE id='module_ids' ");
				}
				$database->query();			
				
				//echo $task;
				//exit;
				
				//add to session that there is a new module	or a copy action		
				$app->setUserState( "com_adminuseraccess.newmodule", $task);	
			}		
		}
	}
	
	function array_to_csv($array){
		$return = '';		
		for($n = 0; $n < count($array); $n++){
			if($n){
				$return .= ',';
			}
			$row = each($array);
			$value = $row['value'];
			if(is_string($value)){
				$value = addslashes($value);
			}	
			$return .= '"'.$value.'"';		
		}		
		return $return;
	}
	
	function csv_to_array($string){		
		$array = array();
		$temp = explode(',', $string);
		for($n = 0; $n < count($temp); $n++){
			$value = str_replace('"','',$temp[$n]);
			$array[] = $value;
		}
		return $array;
	}
	
		
}

?>